require("dotenv").config();
const express = require("express");
const mongoose = require("mongoose");
const cors = require("cors");
const authRoutes = require("./routes/auth.route.js");
const heroRoutes = require("./routes/hero.route.js");
const jobRoutes = require("./routes/job.route.js");
const userRoutes = require("./routes/user.route.js");
const employerRoutes = require("./routes/employer.route.js");
const tpoRoutes = require("./routes/tpo.route.js");
const app = express();
const PORT = process.env.PORT || 5000;


// CORS configure for React dev server + production URL
// const corsOptions = {
//   origin: ['https://jobtalk.skandaxhire.com', 'http://localhost:3000'], 
//   methods: ['GET', 'POST', 'PUT', 'PATCH', 'DELETE'],
//   allowedHeaders: ['Content-Type', 'Authorization'],
//   credentials: true, // If you're using cookies or auth headers
// };

// Middleware
// app.use(cors(corsOptions));
// app.options('*', cors(corsOptions));
app.use(cors());
app.options('*', cors());

app.use(express.json());
app.use(express.urlencoded({ extended: false }));

// Routes
app.use("/auth", authRoutes);
app.use("/hero", heroRoutes);
app.use("/jobs", jobRoutes);
app.use("/user", userRoutes);
app.use("/employer", employerRoutes);
app.use("/tpo", tpoRoutes);

// MongoDB Connection
mongoose
  .connect(
    "mongodb+srv://soundarkumarsaravanan:euZ34yhupl5fgtVL@cluster0.5hyloaf.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0"
  )
  .then(() => {
    console.log("Connected to MongoDB");
    app.listen(PORT, () => {
      console.log(`Server is running on port ${PORT}`);
    });
  })
  .catch((err) => {
    console.log("MongoDB connection error:", err);
  });
