// hero.model.js

const mongoose = require("mongoose");

const heroSchema = new mongoose.Schema(
  {
    featuredCompanies: [
      {
        name: { type: String, required: true },
        website: { type: String, required: true },
        logo: { type: String, required: true },
      },
    ],
    heroTitles: [
      {
        title: { type: String, required: true },
        description: { type: String, required: true },
        image: { type: String, required: true },
        details: { type: String, required: true },
      },
    ],
    brochure: {
      brochureImage: { type: String, required: true },
      description: { type: String, required: true },
      expireDate: { type: Date, required: true },
      title: { type: String, required: true },
      createdAt: { type: Date, required: true },
    },
  },
  {
    timestamps: true,
  }
);

const Hero = mongoose.model("Hero", heroSchema);

module.exports = Hero;
