// job.model.js

const mongoose = require("mongoose");

const jobSchema = new mongoose.Schema(
  {
    title: { type: String, required: true },
    shortDescription: { type: String, required: true },
    detailedDescription: { type: String, required: true },

    categories: { type: [String], default: [] },

    companyName: { type: String, required: true },
    companyLogo: { type: String, required: true },

    workModes: { type: [String], default: [] }, // e.g., Remote, Hybrid, On-site

    applicantsCount: { type: Number, default: 0 },

    minSalary: { type: Number, required: false },
    maxSalary: { type: Number, required: false },

    preferedStates: { type: [String], default: [] },
    preferedCities: { type: [String], default: [] },
    preferedSkills: { type: [String], default: [] },
    preferedExperience: { type: [String], default: [] },

    createdBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    applicants: [
      {
        userId: {
          type: mongoose.Schema.Types.ObjectId,
          ref: "User",
          required: true,
        },
        appliedAt: { type: Date, default: Date.now },
      },
    ],
  },
  {
    timestamps: true, // Auto createdAt and updatedAt
  }
);

const Job = mongoose.model("Job", jobSchema);

module.exports = Job;
