const express = require("express");
const router = express.Router();
const {
  sendOtp,
  verifyEmail,
  register,
  login,
  resetPassword,
} = require("../controllers/auth.controller.js");

// OTP Routes
router.post("/send-otp", sendOtp);
router.post("/verify-email", verifyEmail);

// Auth Routes
router.post("/register", register);
router.post("/login", login);

router.post("/reset-password", resetPassword);

module.exports = router;
