const Hero = require("../models/hero.model");
const Job = require("../models/job.model");
const User = require("../models/user.model");

exports.getHero = async (req, res) => {
  const totalJobs = await Job.countDocuments();
  const totalEmployers = await User.countDocuments({ role: "employer" });
  const totalTPOs = await User.countDocuments({ role: "TPO" });
  const totalStudents = await User.countDocuments({ role: "user" });
  const hero = await Hero.findOne();
  res.status(200).json({
    hero,
    totalJobs,
    totalEmployers,
    totalTPOs,
    totalStudents,
  });
};

exports.updateHeroTitles = async (req, res) => {
  try {
    const { heroTitles } = req.body;

    if (!heroTitles || !Array.isArray(heroTitles)) {
      return res.status(400).json({ message: "heroTitles must be an array" });
    }

    //singletone.
    let hero = await Hero.findOne();

    if (!hero) {
      hero = new Hero({ heroTitles, featuredCompanies: [], brochure: {} });
    } else {
      hero.heroTitles = heroTitles;
    }

    await hero.save();

    return res
      .status(200)
      .json({ message: "Hero titles updated successfully", hero });
  } catch (error) {
    console.error("Error updating hero titles:", error);
    return res.status(500).json({ message: "Internal server error" });
  }
};

exports.updateFeaturedCompanies = async (req, res) => {
  try {
    const { featuredCompanies } = req.body;

    if (!featuredCompanies || !Array.isArray(featuredCompanies)) {
      return res
        .status(400)
        .json({ message: "featuredCompanies must be an array" });
    }

    let hero = await Hero.findOne();

    if (!hero) {
      hero = new Hero({ featuredCompanies: [], brochure: {} });
    } else {
      hero.featuredCompanies = featuredCompanies;
    }

    await hero.save();

    return res
      .status(200)
      .json({ message: "Featured companies updated successfully", hero });
  } catch (error) {
    console.error("Error updating featured companies:", error);
    return res.status(500).json({ message: "Internal server error" });
  }
};

exports.updateBrochure = async (req, res) => {
  try {
    const { brochure } = req.body;

    if (
      !brochure ||
      !brochure.brochureImage ||
      !brochure.title ||
      !brochure.description ||
      !brochure.expireDate ||
      !brochure.createdAt
    ) {
      return res.status(400).json({
        message: "All brochure fields are required",
        error: "Missing required fields",
      });
    }

    //singletone.
    let hero = await Hero.findOne();

    if (!hero) {
      hero = new Hero({
        brochure: {
          brochureImage: brochure.brochureImage,
          title: brochure.title,
          description: brochure.description,
          expireDate: brochure.expireDate,
          createdAt: brochure.createdAt,
        },
        featuredCompanies: [],
        heroTitles: [],
      });
    } else {
      hero.brochure = {
        brochureImage: brochure.brochureImage,
        title: brochure.title,
        description: brochure.description,
        expireDate: brochure.expireDate,
        createdAt: brochure.createdAt,
      };
    }

    await hero.save();

    res.status(200).json({
      message: "Brochure updated successfully",
      data: hero,
    });
  } catch (error) {
    console.error("Error updating brochure:", error);
    res.status(500).json({
      message: "Something went wrong",
      error: error.message,
    });
  }
};
