const express = require("express");
const authenticateToken = require("../utils/authenticateToken");
const {
  getEmployerJobs,
  getReceivedApplications,
  getUserDetails,
  updateStatus,
} = require("../controllers/employer.controller");
const router = express.Router();

router.get("/jobs", authenticateToken, getEmployerJobs);
router.get("/applications", authenticateToken, getReceivedApplications);
router.get("/user/:id", authenticateToken, getUserDetails);
router.put("/status", authenticateToken, updateStatus);
module.exports = router;
