const express = require("express");
const router = express.Router();
const authenticateToken = require("../utils/authenticateToken");

const {
  getProfile,
  updateProfile,
  getSavedJobs,
  getAppliedJobs,
  sendEmail,
} = require("../controllers/user.controller");

router.get("/profile", authenticateToken, getProfile);
router.put("/profile", authenticateToken, updateProfile);
router.get("/saved-jobs", authenticateToken, getSavedJobs);
router.get("/applied-jobs", authenticateToken, getAppliedJobs);

router.post("/send-email", sendEmail);

module.exports = router;
